// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   uniform mat4 agk_World;
   uniform mat4 agk_View;
   uniform mat4 agk_Proj;
   uniform mat4 agk_ViewProj;
   uniform vec3 agk_CameraPos;

//--------------
// tweaks
//--------------
   uniform mat4 MoonProj;
   uniform mat3 StarsAngle;

//--------------
// attributes
//--------------
    attribute vec3 position;

//--------------
// Vs Out
//--------------
    varying vec3 Vs_WorldPos;
    varying vec3 Vs_ViewVec;
    varying vec4 Vs_Proj;
    varying vec4 Vs_Moon;
    varying vec3 Vs_Stars;

//--------------
// vertex shader
//--------------
   void main()
     {
	vec3 WorldPos=(agk_World*vec4(position,1.0)).xyz;
	vec4 Pos=agk_ViewProj*vec4(WorldPos,1.0);
	gl_Position=Pos;
	Vs_WorldPos=WorldPos;
	vec3 ViewVec=WorldPos-agk_CameraPos;
	Vs_ViewVec=ViewVec;
        Vs_Proj=vec4(Pos.x*0.5+0.5*Pos.w,Pos.y*0.5+0.5*Pos.w,Pos.z,Pos.w);
	vec4 MoonProj=MoonProj*vec4(position,1.0);
	Vs_Moon=vec4(MoonProj.x*0.5+0.5*MoonProj.w,0.5*MoonProj.w-MoonProj.y*0.5,MoonProj.z,MoonProj.w);
	Vs_Stars=StarsAngle*(agk_CameraPos-WorldPos);
     }
